/**
 * An abstract class that represents dishes that are available in a
 * fast-food restuarant.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */

public class AbstractDish
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new dish with the given name and price.
    *
    * @param theName the name of this dish.
    * @param thePrice the price of this dish.
    */
   protected AbstractDish(String theName, int thePrice)
   {  name = theName;
      price = thePrice;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the name of this dish.
    *
    * @return the name of this dish.
    */
   public String getName()
   {  return name;
   }

   /**
    * Returns the price of this dish.
    *
    * @return the price of this dish.
    */
   public int getPrice()
   {  return price;
   }

/* --Common object interface------------------------------------------- */

   /**
    * Returns a string representation of this dish, which includes
    * the dish's name and price.
    *
    * @return a string representation of this dish.
    */
   public String toString()
   {  return name + " (" + price + "p)";
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The name of the dish.
    */
   protected String name;

   /**
    * The price of the dish.
    */
   protected int price;
}
