import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that allows testing of a till, its GUI and the GUIs controller
 * (listener).
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class TillMain
{
   public static void main(String[] args)
   {  /* Create till, till GUI and controller.
       */
      Till till = new Till(1000); // 1000 is the float (10 pounds)
      TillController controller = new TillController();
      TillGUI gui = new TillGUI(controller);
      controller.setTill(till);
      controller.setGUI(gui);

      /* Till GUIs are simply subclasses of JPanel, so we add the GUI
         to a JFrame and make the JFrame visible.
       */
      JFrame frm = new JFrame();
      Container contentPane = frm.getContentPane();
      contentPane.add(gui);
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      frm.pack();
      frm.setLocation(100, 100);
      frm.setVisible(true);
   }
}