import java.awt.event.*;

/**
 * A class that represents objects that respond to till events.
 * @author Derek Bridge
 */
public class TillController
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new till controller object that can respond to till
    * events.
    */
   public TillController()
   {
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
/* --Setters----------------------------------------------------------- */

   /**
    * Sets the till that this controller operates upon.
    *
    * @param theTill the till this controller operates upon.
    */
   public void setTill(Till theTill)
   {  till = theTill;
   }

   /**
    * Sets the gui that this controller controls (listens to).
    *
    * @param theGUI the gui this controller listens to.
    */
   public void setGUI(TillGUI theGUI)
   {  gui = theGUI;
      updateGUI();
   }

   /**
    * The handler method: responds to the three main actions of a till
    * GUI: entering a price for a customer purchase (ENTER); concluding
    * a transaction successfully (SUBMIT) or aborting a transaction
    * (CANCEL).
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  String str = ae.getActionCommand();
      if (str.equals(TillGUI.ENTER)) 
      {  till.ringUpItem(gui.getPriceEntered()); 
         updateGUI();
      }
      else if (str.equals(TillGUI.SUBMIT))
      {  till.ringUpItem(gui.getPriceEntered());
         till.submitTransaction();
         updateGUI();
      }
      else // i.e. cancel
      {  till.cancelTransaction();
         updateGUI();
      }
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/
   /**
    * Sets all the fields of the GUI with values gotten from the till.
    */
   private void updateGUI()
   {  gui.setPriceEntered(0);
      gui.setTotalOwed(till.getTotalOwed());
      gui.setTillFloat(till.getTillFloat());
      gui.setTillTotal(till.getTillTotal());
      gui.setTransactionCount(till.getTransactionCount());
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The till that is being operated upon.
    */
   private Till till;

   /**
    * The GUI for the till.
    */
   private TillGUI gui;
}