/**
 * A class that represents cash till objects.
 * Till objects keep track of floats, takings and numbers of 
 * transactions.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Till
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new till object with the given initial float.
    *
    * @param theTillFloat the initial float in the till, prior to any
    * transactions.
    */
   public Till(int theTillFloat)
   {  tillFloat = theTillFloat;
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the float that was in the till.
    *
    * @return the amount of the float in the till.
    */
   public int getTillFloat()
   {  return tillFloat;
   }

   /**
    * Returns the amount of money taken.
    *
    * @return the amount of the takings.
    */
   public int getTakings()
   {  return takings;
   }

   /**
    * Returns the amount of money that should be in the till.
    *
    * @return the amount of money that should be in the till.
    */
   public int getTillTotal()
   {  return takings + tillFloat;
   }

   /**
    * Returns the number of transactions there have been.
    *
    * @return the number of transactions.
    */
   public int getTransactionCount()
   {  return transactionCount;
   }

   /**
    * Returns the total amount owed by this customer.
    *
    * @return the total amount owed by this customer.
    */
   public int getTotalOwed()
   {  return amountOwedByThisCust;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Rings up an item, i.e. adds the price of the latest item that is
    * being purchased by this customer to the running total owed by
    * this customer.
    *
    * @param theItemPrice the price of the item.
    */
   public void ringUpItem(int theItemPrice)
   {  amountOwedByThisCust += theItemPrice;
   }

   /**
    * Concludes the transaction with this customer by updating the takings
    * and the transaction count, and prepares for next customer.
    */
   public void submitTransaction()
   {  transactionCount++;
      takings += amountOwedByThisCust;
      amountOwedByThisCust = 0;
   }

   /**
    * Cancels this customer's transaction and prepares for next customer.
    */
   public void cancelTransaction()
   {  amountOwedByThisCust = 0;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
                         
   /**
    * The float that was in the till.
    */
   private int tillFloat;

   /**
    * The takings, i.e. the amount fleeced from customers.
    * (The total in the till is the takings plus the float.)
    */
   private int takings;

   /**
    * The number of transactions (customers) processed.
    */
   private int transactionCount;

   /**
    * The amount the present customer has rung up so far.
    */
   private int amountOwedByThisCust;
}
