import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents numeric keypads.
 * (This one illustrates layout using border layout and panels.)
 * @author Derek Bridge
 */
public class NumericPad5
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new numeric keypad.
    *
    */
   public NumericPad5()
   {  super();

      digitB = new JButton[10];
      for (int i = 0; i < 10; i++)
      {  digitB[i] = new JButton("" + i);
      }
      enterB = new JButton("Enter");

      setLayout(new BorderLayout());

      add(enterB, BorderLayout.EAST);

      JPanel digitP = new JPanel();
      digitP.setLayout(new BorderLayout());

      digitP.add(digitB[0], BorderLayout.NORTH);

      JPanel nonZeroDigitP = new JPanel();
      nonZeroDigitP.setLayout(new GridLayout(3, 3));
      for (int i = 1; i < 10; i++)
      {  nonZeroDigitP.add(digitB[i]);
      }

      digitP.add(nonZeroDigitP, BorderLayout.CENTER);

      add(digitP, BorderLayout.CENTER);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Array of digit buttons.
    */
   private JButton[] digitB;

   /**
    * The Enter button.
    */
   private JButton enterB;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  NumericPad5 pad = new NumericPad5();
      JFrame frm = new JFrame("Border layout");
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      Container contentPane = frm.getContentPane();
      contentPane.add(pad);
      frm.pack();
      frm.setLocation(100, 100);
      frm.setVisible(true);
   }
}
