import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents numeric keypads.
 * (This one illustrates layout using flow layout.)
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class NumericPad3
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new numeric keypad.
    *
    */
   public NumericPad3()
   {  super();

      digitB = new JButton[10];
      for (int i = 0; i < 10; i++)
      {  digitB[i] = new JButton("" + i);
      }
      enterB = new JButton("Enter");

      setLayout(new FlowLayout());

      add(digitB[0]);

      for (int i = 1; i < 10; i++)
      {  add(digitB[i]);
      }

      add(enterB);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Array of digit buttons.
    */
   private JButton[] digitB;

   /**
    * The Enter button.
    */
   private JButton enterB;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/

   public static void main(String[] args)
   {  NumericPad3 pad = new NumericPad3();
      JFrame frm = new JFrame("Flow layout");
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      Container contentPane = frm.getContentPane();
      contentPane.add(pad);
      frm.setBounds(100, 100, 300, 200);
      frm.setVisible(true);
   }
}
