import java.awt.event.*;

/**
 * A class that represents objects that convert centigrade temperatures
 * to Fahrenheit temperatures in response to button clicks.
 * @author Derek Bridge
 */
public class CompFahrBtnLstnr
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object for converting centigrade temperatures
    * to Fahrenheit temperatures in response to button clicks.
    *
    * @param theGUI the temperature conversion GUI on which the button is
    * located.
    */
   public CompFahrBtnLstnr(TempConversionGUI theGUI)
   {  gui = theGUI;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Gets a centigrade temperature from a GUI, converts it to
    * Fahrenheit and informs the GUI of the new value.
    * Invoked in response to button clicks.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  int cent = gui.getCentField();
      int fahr = (int) Math.round(cent * 9.0 / 5.0 + 32);
      gui.setFahrField(fahr);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * A reference to the gui on which the button for which this is
    * a listener resides.
    */
   private TempConversionGUI gui;
}