/**
 * A interface that specifies stack objects.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public interface Stack 
{
   /**
    * Returns the number of objects in this stack.
    *
    * @return the number of objects in this stack.
    */
   public int size();

   /**
    * Tests whether this stack contains no objects.
    *
    * @return true if the stack is empty; false otherwise.
    */
   public boolean isEmpty(); 

   /**
    * Returns the top item of the stack. (It leaves the item
    * on the stack and returns a reference to it.)
    *
    * @param the top of the stack.
    */
   public Object top(); 

   /**
    * Pushes an object onto the top of this stack.
    *
    * @param obj the object to push onto the stack.
    */
   public void push (Object element); 

   /**
    * Removes the object at the top of this stack and returns 
    * that object.
    *
    * @param the top of the stack.
    */
   public Object pop(); 
}