/**
 * A class that represents stacks, implemented using arrays.
 * @author Kieran Herley & Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class ArrayBasedStack 
   implements Stack 
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new empty stack of a default capacity.
    */
   public ArrayBasedStack()        
   {  this(CAPACITY);
   }

   /**
    * Allocates a new empty stack of a specified capacity.
    *
    * @param theCapacity the maximum capacity of the stack.
    */
   public ArrayBasedStack(int theCapacity)
   {  capacity = theCapacity;
      s = new Object[capacity];
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public constants-------------------------------------------------- */

   /**
    * The default maximum capacity of the stack.
    */
   public static final int CAPACITY = 1000; 

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the number of objects in this stack.
    *
    * @return the number of objects in this stack.
    */
   public int size()           
   {  return (top + 1);
   }


   /**
    * Tests whether this stack contains no objects.
    *
    * @return true if the stack is empty; false otherwise.
    */
   public boolean isEmpty()     
   {  return (top < 0);
   }

   /**
    * Returns the top item of the stack. (It leaves the item
    * on the stack and returns a reference to it.)
    *
    * @param the top of the stack.
    */
   public Object top()
   {  if (isEmpty())
      {  System.out.println("Stack is empty.");
         System.exit(1);
      }
      return s[top];
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Pushes an object onto the top of this stack.
    *
    * @param obj the object to push onto the stack.
    */    
   public void push(Object obj)  
   {  if (size() == capacity) 
      // copy array into one of larger size
      {  Object temp[] = new Object[2*capacity];
         for (int i = 0; i< capacity; i++)
         {  temp[i] = s[i];
         }
         s = temp;
         capacity = 2*capacity;
      }
      s[++top] = obj;
    }

   /**
    * Removes the object at the top of this stack and returns 
    * that object.
    *
    * @param the top of the stack.
    */
   public Object pop() 
   {  Object elem;
      if (isEmpty())
      {  System.out.println("Stack is Empty.");
         System.exit(1);
      }
      elem = s[top];
      s[top--] = null;  
      return elem;
   }

   
/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/ 
   /**
    * The maximum capacity of this stack.
    */
   private int capacity;

   /**
    * The array used to implement the stack.
    */
   private Object s[];

   /**
    * An index to the array, used to keep track of the top of the
    * stack.
    */
   private int top = -1; 
}

