/**
 * A class that represents films that are in the inventory
 * of a camera shop.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Film 
   extends InventoryItem
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new inventory item.
    *
    * @param aDescription describes the inventory item.
    * @param anInventoryNumber identifies the item.
    * @param theQuantityOnHand how many there are in the store.
    * @param thePrice how much each one costs.
    * @param theRecommendedTemp the recommeneded storage temperature.
    * @param theNumberOfExposures the number of exposures on the film.
    */
   public Film(String aDescription, int anInventoryNumber, 
      int theQuantityOnHand, int thePrice, int theRecommendedTemp,
      int theNumberOfExposures)
   {  super(aDescription, anInventoryNumber, theQuantityOnHand, thePrice);
      recommendedTemp = theRecommendedTemp;
      numberOfExposures = theNumberOfExposures;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this film on the screen.
    */
   public void display()
   {  System.out.println("Film " + inventoryNumber +
         quantityOnHand + " " +  numberOfExposures);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The recommended storage temperature.
    */
   protected int recommendedTemp;

   /**
    * the number of exposures on the film.
    */
   protected int numberOfExposures;
}