/**
 * A class that represents flash guns that are in the inventory
 * of a camera shop.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class FlashGun 
   extends InventoryItem
{  
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new inventory item.
    *
    * @param aDescription describes the inventory item.
    * @param anInventoryNumber identifies the item.
    * @param theQuantityOnHand how many there are in the store.
    * @param thePrice how much each one costs.
    * @param theGuideNumber the light output that determines proper exposure.
    */
   public FlashGun(String aDescription, int anInventoryNumber, 
      int theQuantityOnHand, int thePrice, int theGuideNumber)
   {  super(aDescription, anInventoryNumber, theQuantityOnHand, thePrice);
      guideNumber = theGuideNumber;
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this flash gun on the screen.
    */
   public void display()
   {  System.out.println("Flash gun " + inventoryNumber +
         quantityOnHand + " " +  guideNumber);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The guide number of this gun (relative light ouput, used to
    * determine correct exposure).
    */
   protected int guideNumber;
}