/**
 * An abstract class that represents various 2D geometric shapes.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public abstract class Shape
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new shape object at the specified co-ordinates.
    *
    * @param theX the x position of the shape.
    * @param theY the y position of the shape.
    */
   public Shape(int theX, int theY)
   {  x = theX;
      y = theY;
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the shape's area.
    *
    * @return the shape's area.
    */
   public abstract double getArea();

   /**
    * Returns a string representation of this shape.
    *
    * @return a string representation of this shape.
    */
   public String toString()
   {  return "Shape at (" + x +
         ", " + y + ")";
   }

   /**
    * Determines whether the specified object is equal to this shape.
    * The result is true if and only if their positions are the same.
    *
    * @param anObject the object to compare this shape against.
    * @return true if their x and y co-ordinates are equal; 
    * false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (this == anObject)
      {  return true;
      }
      else if (anObject == null ||
         getClass() != anObject.getClass())
      {  return false;
      }
      else
      {  Shape other = (Shape) anObject;
         return x == other.x &&
            y == other.y;
      }
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Changes the position of the shape.
    *
    * @param theXChange the amount by which to move in the x direction
    * (positive moves right, negative moves left).
    * @param theXChange the amount by which to move in the y direction
    * (positive moves up, negative moves down).
    */
   public void move(int theXChange, 
      int theYChange)
   {  x += theXChange;
      y += theYChange;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The x position of the shape.
    */
   protected int x;

   /**
    * The y position of the shape.
    */
   protected int y;
}