/**
 * A class that represents rounded rectangles
 * (i.e. rectangles with rounded corners).
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class RoundedRectangle
   extends Rectangle
{
   /**
    * Allocates a new rectangle object at the specified co-ordinates
    * with the specified length, height and arc radius.
    *
    * @param theX the x position of the shape.
    * @param theY the y position of the shape.
    * @param theLength the rectangle's length.
    * @param theHeight the rectangle's height.
    * @param theArcRadius the radius of the circle
    * that is used for drawing the rounded corners.
    */
   public RoundedRectangle(int theX, 
      int theY, int theLength, 
      int theHeight, int theArcRadius)
   {  super(theX, theY, theLength, 
         theHeight);
      arcRadius = theArcRadius;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns a string representation of this rounded rectangle.
    *
    * @return a string representation of this rounded rectangle.
    */
   public String toString()
   {  return "Rounded Rectangle of " +
         "length " + length + ", height " + 
         height + " & arc radius " +
         arcRadius + " at (" + x + ", " + 
         y + ")";
   }

   /**
    * Determines whether the specified object is equal to this 
    * rounded rectangle.
    * The result is true if and only if their positions, lengths, heights
    * & arc radii are the same.
    *
    * @param anObject the object to compare this shape against.
    * @return true if their x and y co-ordinates are equal and if their
    * lengths, heights & arc radii are equal; false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (! super.equals(anObject))
      {  return false;
      }
      RoundedRectangle other = 
         (RoundedRectangle) anObject;
      return arcRadius == other.arcRadius;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The radius of the circle that is used to draw the rectangle's
    * rounded corners.
    */
   protected int arcRadius;
}