/**
 * A class that represents rectangles.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Rectangle
   extends Shape
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new rectangle object at the specified co-ordinates
    * with the specified length & height.
    *
    * @param theX the x position of the shape.
    * @param theY the y position of the shape.
    * @param theLength the rectangle's length.
    * @param theHeight the rectangle's height.
    */
   public Rectangle(int theX, int theY, 
      int theLength, int theHeight)
   {  super(theX, theY);
      length = theLength;
      height = theHeight;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the rectangle's area.
    *
    * @return the rectangle's area.
    */
   public double getArea()
   {  return length * height;
   }

   /**
    * Returns a string representation of this rectangle.
    *
    * @return a string representation of this rectangle.
    */
   public String toString()
   {  return "Rectangle of length " +
         length + " & height " + height + 
         " at (" + x + ", " + y + ")";
   }

   /**
    * Determines whether the specified object is equal to this rectangle.
    * The result is true if and only if their positions, lengths & heights
    * are the same.
    *
    * @param anObject the object to compare this shape against.
    * @return true if their x and y co-ordinates are equal and if their
    * lengths & heights are equal; false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (! super.equals(anObject))
      {  return false;
      }
      Rectangle other = (Rectangle) anObject;
      return length == other.length &&
         height == other.height;
   }


/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The rectangle's length.
    */
   protected int length;

   /**
    * The rectangle's height.
    */
   protected int height;
}