/**
 * A class that represents circles.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Circle
   extends Shape
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new circle object at the specified co-ordinates
    * with the specified radius.
    *
    * @param theX the x position of the shape.
    * @param theY the y position of the shape.
    * @param theRadius the circle's radius.
    */
   public Circle(int theX, int theY, 
      int theRadius)
   {  super(theX, theY);
      radius = theRadius;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the circle's area.
    *
    * @return the circle's area.
    */
   public double getArea()
   {  return Math.PI * radius * radius;
   }

   /**
    * Returns a string representation of this circle.
    *
    * @return a string representation of this circle.
    */
   public String toString()
   {  return "Circle of radius " +
         radius + " at (" + x +
         ", " + y + ")";
   }

   /**
    * Determines whether the specified object is equal to this circle.
    * The result is true if and only if their positions and radii are 
    * the same.
    *
    * @param anObject the object to compare this shape against.
    * @return true if their x and y co-ordinates are equal and if their
    * radii are equal; false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (! super.equals(anObject))
      {  return false;
      }
      Circle other = (Circle) anObject;
      return radius == other.radius;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The circle's radius.
    */
   protected int radius;
}