/**
 * A class that represents an academic's scholarly publications.
 * @author Derek Bridge
 */
public class Publication
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new publication object.
    *
    * @param the publication's title.
    * @param the name of the publication's author.
    * @param the year of publication.
    */
   public Publication(String theTitle, PersonName theAuthor, 
      int theYearOfPub)
   {  title = theTitle;
      author = theAuthor;
      yearOfPub = theYearOfPub;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/


/* --Getters----------------------------------------------------------- */

   /**
    * Returns the publication's title.
    *
    * @return the publication's title.
    */
   public String getTitle()
   {  return title;
   }

   /**
    * Returns the name of the publication's author.
    *
    * @return the name of the publication's author.
    */
   public PersonName getAuthor()
   {  return author;
   }

   /**
    * Returns the year of publication.
    *
    * @return the year of publication.
    */
   public int getYearOfPub()
   {  return yearOfPub;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the publication's title to the new specified title.
    *
    * @param the new title.
    */
   public void setTitle(String theTitle)
   {  title = theTitle;
   }

/* --Common object interface------------------------------------------- */

   /**
    * Determines whether the specified object is equal to this 
    * Publication.
    * The result is true if and only if the author, title and
    * year of publication are all equal.
    *
    * @param anObject the object to compare this Publication against.
    * @return true if the author, title and year of publication
    * are equal; false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (this == anObject)
      {  return true;
      }
      else if (anObject == null || 
         getClass() != anObject.getClass())
      {  return false;
      }
      Publication other = 
                     (Publication) anObject;
      return (author.equals(other.author) && 
         title.equals(other.title) &&
         yearOfPub == other.yearOfPub);
   }

   /**
    * Returns a string representation of this Publication.
    *
    * @return a string representation of this Publication.
    */
   public String toString()
   {  return author.getFullName() + " " + 
         title + " " + yearOfPub;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The title of the publication.
    */
   protected String title;

   /**
    * The name of the publication's author.
    */
   protected PersonName author;

   /**
    * The year of publication.
    */
   protected int yearOfPub;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  Publication p1 = new Publication(
         "Defining and Combining Symmetric and Asymmetric Similarity Measures",
         new PersonName("Dr.", "Derek", "Bridge"),
         1998);
      System.out.println(p1);
      
      Publication p2 = new Publication(
         "Defining and Combining Symmetric and Asymmetric Similarity Measures",
         new PersonName("Dr.", "Derek", "Bridge"),
         1998);
      System.out.println(p1 == p2);
      System.out.println(p1.equals(p2));
   }
}
