/**
 * A class that represents students of the CS Department.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class CSStudent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new CS student object.
    *
    * @param aName the student's name.
    */
   public CSStudent(PersonName aName)
   {  name = aName;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the student's name.
    *
    * @return the student's name.
    */
   public PersonName getName()
   {  return name;
   }

   /**
    * Returns the student's supervisor.
    *
    * @return the student's supervisor.
    */
   public CSLecturer getSupervisor()
   {  return supervisor;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Assigns a supervisor to the student.
    *
    * @param theSupervisor the new supervisor.
    */
   public void setSupervisor(CSLecturer theSupervisor)
   {  supervisor = theSupervisor;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The student's name.
    */
   private PersonName name;

   /**
    * The student's supervisor.
    */
   private CSLecturer supervisor;
}
