/**
 * A class that represents lecturers in the CS Department.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class CSLecturer
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new CS lecturer object.
    *
    * @param aName the lecturer's name.
    */
   public CSLecturer(PersonName aName)
   {  name = aName;
      supervisees = new CSStudent[MAX_SUPERVISEES];
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public class constants-------------------------------------------- */

   /**
    * The maximum number of supervisees a lecturer can have.
    */
   public static final int MAX_SUPERVISEES = 3;

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the lecturer's name.
    *
    * @return the lecturer's name.
    */
   public PersonName getName()
   {  return name;
   }

   /**
    * Returns the lecturer's supervisees.
    *
    * @return the lecturer's supervisees.
    */
   public CSStudent[] getSupervisees()
   {  return supervisees;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Assign a supervisee to the lecturer.
    *
    * @param aSupervisee a new supervisee.
    */
   public void addSupervisee(CSStudent aSupervisee)
   {  /* Insert the new supervisee into the data structure.
         In this simple version, the data structure is an 
         array.
         I use a very inefficient way of doing the insertion:
         search thro' the array starting at cell 0, until I
         find one that is empty (contains null). This is where
         I put the new supervisee. (If there is no empty cell,
         then the lecturer has a full load of supervisees.)
       */
      int i;
      for (i = 0; i < supervisees.length; i++)
      {  if (supervisees[i] == null)
         {  break;
         }
      }
      if (i < supervisees.length) // an empty cell was found
      {  supervisees[i] = aSupervisee;
      }
      else // we reached the end of the array having found no empty cell
      {  // do something appropriate in these circumstances
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The lecturer's name.
    */
   private PersonName name;

   /**
    * The lecturer's supervisees.
    */
   private CSStudent[] supervisees;
}
