/**
* A class that represents library borrowers.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Borrower
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new borrower object 
    * with the given name.
    *
    * @param aName the borrower's name.
    */
   public Borrower(PersonName aName)
   {  name = aName;
      borrowerNum = nextBorrowerNum;
      nextBorrowerNum++;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this borrower
    * and the book s/he has on loan
    * (if any).
    */
   public void display()
   {  System.out.println(borrowerNum +
         ": " + name.getLastFirst());
      if (bookOnLoan != null)
      {  bookOnLoan.display();
      }
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Record the fact that this borrower
    * has borrowed a copy of the specified
    * book.
    * Should only be invoked when the
    * number of copies on the shelves > 0
    * and when the borrower doesn't
    * already have a book on loan.
    */
   public void takeOut(LibraryBook aBook)
   {  bookOnLoan = aBook;
      aBook.takeOut();
   }

   /**
    * Record the fact that this borrower
    * has returned whatever book s/he
    * has on loan.
    * Should only be invoked when the
    * boorower does have a book on
    * loan.
    */
   public void bringBack()
   {  bookOnLoan.bringBack();
      bookOnLoan = null;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The borrower's unique number.
    */
   private int borrowerNum; 

   /**
    * The borrower's name.
    */
   private PersonName name; 

   /**
    * The book the borrower has on loan (null if s/he has no book on loan)
    */
   private LibraryBook bookOnLoan; 

   /**
    * The number we will use as the borrower number for the next borrower 
    * we create.
    */
   private static int nextBorrowerNum = 1; 
}