import java.util.*;

/**
 * A class that represents collections of customers.
 * @author Derek Bridge
 */
public class CustomerCollection
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new, empty collection of customers.
    */
   public CustomerCollection()
   {  customers = new Vector();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns all customers in the collection.
    */
   public Vector findAll()
   {  return customers;
   }

   /**
    * Returns the customer in the collection with the specified 
    * identification number (if any). Although there can only be 
    * one such customer, a Vector is returned for consistency with
    * other search methods. It also means that with no match,
    * an empty Vector can be returned.
    *
    * @param theIdNum the identification number being sought.
    * @return the customer object with the specified id number or 
    * an empty Vector if there is no such customer
    */
   public Vector findById(String theIdNum)
   {  Vector matchList = new Vector();
      boolean found = false;
      Customer cust = null;
      Enumeration e = customers.elements();
      while (e.hasMoreElements() && ! found)
      {  cust = (Customer) e.nextElement();
         found = cust.getIdNum().equals(theIdNum);
      }
      if (found)
      {  matchList.addElement(cust);
      }
      return matchList;
   }

   /**
    * Returns the customers in the collection whose names are equal to or
    * are similar to the specified name.
    *
    * @param theName the name being sought; must be non-null & non-empty.
    * @return an enumeration of the customers in the colection whose
    * names match the specified name.
    */
   public Vector findByName(String theName)
   {  Vector matchList = new Vector();
      Enumeration e = customers.elements();
      while (e.hasMoreElements())
      {  Customer cust = (Customer) e.nextElement();
         if (StringUtility.matches(cust.getName(), theName))
         {  matchList.addElement(cust);
         }
      }
      return matchList;
   }


/* --Setters----------------------------------------------------------- */

   /**
    * Add the specified customer object to the collection.
    *
    * @param theCust the customer being added to the collection; must be 
    * non-null & not already in the collection.
    */
   public void add(Customer theCust)
   {  customers.addElement(theCust);
   }

   /**
    * Remove the specified customer from the collection.
    *
    * @param theCustomer the customer to be removed; must be non-null and
    * a customer already in the collection.
    */
   public void remove(Customer theCustomer)
   {  customers.removeElement(theCustomer);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private Vector customers;
}
