import java.util.*;

/**
 * A class that represents customer objects.
 * @author Derek Bridge
 */
public class Customer
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new customer object with the given name and address.
    *
    * @param theName the customer's name; must be non-null & non-empty.
    * @param theHouseStreet the customer's house name/number and street name;
    * must be non-null & non-empty.
    * @param theTownCounty the customer's town name and county name; must
    * be non-null & non-empty.
    * @param theTeleNum the customer's telephone number; must be non-null.
    */
   public Customer(String theName, String theHouseStreet,
      String theTownCounty, String theTeleNum)
   {  idNum = PREFIX + nextIdNum;
      nextIdNum++;
      name = theName;
      houseStreet = theHouseStreet;
      townCounty = theTownCounty;
      teleNum = theTeleNum;
      currentOrders = new Vector();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the customer's unique identification number
    *
    * @return the identification number.
    */
   public String getIdNum()
   {  return idNum;
   }

   /**
    * Returns the customer's name.
    *
    * @return the name.
    */
   public String getName()
   {  return name;
   }

   /**
    * Returns the customer's house number/name and street name.
    *
    * @return the house number/name and street name.
    */
   public String getHouseStreet()
   {  return houseStreet;
   }

   /**
    * Returns the customer's town name/county name.
    *
    * @return the town name/county name.
    */
   public String getTownCounty()
   {  return townCounty;
   }

   /**
    * Returns the customer's telephone number.
    *
    * @return the telephone number.
    */
   public String getTeleNum()
   {  return teleNum;
   }

   /**
    * Returns the customer's current orders.
    *
    * @return the customer's current orders.
    */
   public Vector getCurrentOrders()
   {  return currentOrders;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the customer's name to the specified value.
    *
    * @param theName the new name; must be non-null & non-empty.
    */
   public void setName(String theName)
   {  name = theName;
   }

   /**
    * Sets the customer's house number/name and street name to the 
    * specified value; must be non-null & non-empty.
    *
    * @param theHouseStreet the new house number/name and street name.
    */
   public void setHouseStreet(String theHouseStreet)
   {  houseStreet = theHouseStreet;
   }

   /**
    * Sets the customer's town name/county name to the specified value.
    *
    * @param theTownCounty the new town name/county name; must be non-null
    * & non-empty.
    */
   public void setTownCounty(String theTownCounty)
   {  townCounty = theTownCounty;
   }

   /**
    * Sets the customer's telephone number to the specified value.
    *
    * @param theTeleNum the new telephone number; must be non-null.
    */
   public void setTeleNum(String theTeleNum)
   {  teleNum = theTeleNum;
   }

   /**
    * Adds an order to the customer's current orders.
    *
    * @param Order the order being added; must be non-null.
    */
   public void addOrder(Order theOrder)
   {  currentOrders.addElement(theOrder);
   }

   /**
    * Removes an order from the customer's current orders.
    *
    * @param theOrder the order to be removed; must be non-null & must be
    * an order already in this customer's collection of orders.
    */
   public void removeOrder(Order theOrder)
   {  currentOrders.removeElement(theOrder);
   }

/* --Common object interface------------------------------------------- */

   /**
    * Returns a string representation of this customer.
    *
    * @return a string representation of this customer.
    */
   public String toString()
   {  return idNum + " " + name + ", " + houseStreet + ", " +
         townCounty + ". Tel: " + teleNum;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private String idNum;
   private String name;
   private String houseStreet;
   private String townCounty;
   private String teleNum;
   private Vector currentOrders;

   private static int nextIdNum = 1000;

   private static final String PREFIX = "CUST";
}
