import java.awt.event.*;

/**
 * A class that represents objects that convert Fahrenheit temperatures
 * to centigrade temperatures or vice versa in response to button clicks.
 * @author Derek Bridge
 */
public class CompTempBtnLstnr
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object for converting Fahrenheit temperatures
    * to centigrade temperatures or vice versa in response to button clicks.
    *
    * @param theGUI the temperature conversion GUI on which the button is
    * located.
    */
   public CompTempBtnLstnr(TempConversionGUI theGUI)
   {  gui = theGUI;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Gets a temperature from a GUI, converts it and informs the GUI of 
    * the new value.
    * Invoked in response to button clicks. The event source may be one
    * of two buttons, depending on whether the user wants to convert
    * Fahrenheit to centigrade or vice versa.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  String btnText = ae.getActionCommand();
      if (btnText.equals(TempConversionGUI.COMPUTE_FAHRENHEIT))
      {  int cent = gui.getCentField();
         int fahr = (int) Math.round(cent * 9.0 / 5.0 + 32);
         gui.setFahrField(fahr);
      }
      else
      {  int fahr = gui.getFahrField();
         int cent = (int) Math.round((fahr - 32) * 5.0 / 9.0);
         gui.setCentField(cent);
      }
   }


/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private TempConversionGUI gui;
}