import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents one particular GUI for Till objects in
 * burger bars.
 * @author Derek Bridge
 */
public class BurgerBarTillGUI 
   extends JPanel
   implements ITillGUI
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new burger bar till GUI object.
    */
   public BurgerBarTillGUI(Till theTill)
   {  /* Store this GUI's till and till controller (listener)
       */
      till = theTill;

      /* Create the two main parts of the GUI
       */
      JPanel custP = createCustPanel();
      JPanel tillTotP = createTillTotPanel();

      /* Layout the 2 parts.
       */
      setBackground(BACK_COLOUR);
      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = new GridBagConstraints();
      setLayout(gbl);
      gbc.fill = GridBagConstraints.NONE;
      gbc.anchor = GridBagConstraints.CENTER;
      gbc.insets = new Insets(20, 0, 0, 0);
      addComp(custP, this, gbl, gbc, 0, 0, 1, 1, 0, 0);
      addComp(tillTotP, this, gbl, gbc, 1, 0, 1, 1, 0, 0);

      /* Initialise the fields in the GUI (this is done by
         querying the till object).
       */
      update();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Return the value in the price textfield.
    *
    * @return the value in the price textfield (as an int).
    */
   public int getPriceEntered()
   {  return Integer.parseInt(priceTF.getText());
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Place a value into the price textfield.
    *
    * @param thePriceEntered the value to be placed into the price textfield
    * (an int).
    */
   public void setPriceEntered(int thePriceEntered)
   {  priceTF.setText("" + thePriceEntered);
   }

   /**
    * Bring the fields of the GUI up-to-date.
    * This is done by using getters on the till object and putting
    * these values into the fields of the GUI.
    */
   public void update()
   {  owedTF.setText("" + till.getTotalOwed());
      floatTF.setText("" + till.getTillFloat());
      tillTotalTF.setText("" + till.getTillTotal());
      transTF.setText("" + till.getTransactionCount());
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/

   /**
    * Creates and lays out the components that deal with the current
    * customer's running total.
    */
   private JPanel createCustPanel()
   {  /* Create the field and label.
       */
      owedLbl = new JLabel("Total:");
      owedLbl.setForeground(FORE_COLOUR);
      owedTF = new JTextField(TF_WIDTH);
      owedTF.setEditable(false);
      owedTF.setBackground(BACK_COLOUR);
      owedTF.setForeground(FORE_COLOUR);

      /* Layout the fields and labels.
       */
      JPanel p = new JPanel();
      p.setBackground(BACK_COLOUR);
      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = new GridBagConstraints();
      p.setLayout(gbl);
      gbc.fill = GridBagConstraints.HORIZONTAL;
      gbc.anchor = GridBagConstraints.WEST;
      gbc.insets = new Insets(4, 0, 0, 0);
      addComp(owedLbl, p, gbl, gbc, 0, 0, 1, 1, 0, 0);
      addComp(Box.createHorizontalStrut(10), p, gbl, gbc,
         1, 1, 1, 1, 0, 0);
      addComp(owedTF, p, gbl, gbc, 0, 1, 1, 1, 0, 0);
   
      return p;
   }

   /**
    * Creates and lays out the components that deal with the till totals:
    * initial float, total takings and number of transactions.
    */
   private JPanel createTillTotPanel()
   {  /* Create the textfields and their labels for showing the till
         information.
       */
      floatLbl = new JLabel("Float:");
      floatLbl.setForeground(FORE_COLOUR);
      floatTF = new JTextField(TF_WIDTH);
      floatTF.setEditable(false);
      floatTF.setBackground(BACK_COLOUR);
      floatTF.setForeground(FORE_COLOUR);
      tillTotalLbl = new JLabel("Till Total:");
      tillTotalLbl.setForeground(FORE_COLOUR);
      tillTotalTF = new JTextField(TF_WIDTH);
      tillTotalTF.setEditable(false);
      tillTotalTF.setBackground(BACK_COLOUR);
      tillTotalTF.setForeground(FORE_COLOUR);
      transLbl = new JLabel("Transactions:");
      transLbl.setForeground(FORE_COLOUR);
      transTF = new JTextField(TF_WIDTH);
      transTF.setEditable(false);
      transTF.setBackground(BACK_COLOUR);
      transTF.setForeground(FORE_COLOUR);

      /* Layout the textfield and their labels.
       */
      JPanel p = new JPanel();
      p.setBackground(BACK_COLOUR);
      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = new GridBagConstraints();
      p.setLayout(gbl);
      gbc.fill = GridBagConstraints.HORIZONTAL;
      gbc.anchor = GridBagConstraints.WEST;
      gbc.insets = new Insets(4, 0, 0, 0);
      addComp(floatLbl, p, gbl, gbc, 0, 0, 1, 1, 0, 0);
      addComp(Box.createHorizontalStrut(10), p, gbl, gbc, 
         0, 1, 1, 1, 0, 0);
      addComp(floatTF, p, gbl, gbc, 0, 2, 1, 1, 0, 0);
      addComp(tillTotalLbl, p, gbl, gbc, 1, 0, 1, 1, 0, 0);
      addComp(Box.createHorizontalStrut(10), p, gbl, gbc,
         1, 1, 1, 1, 0, 0);
      addComp(tillTotalTF, p, gbl, gbc, 1, 2, 1, 1, 0, 0);
      addComp(transLbl, p, gbl, gbc, 2, 0, 1, 1, 0, 0);
      addComp(Box.createHorizontalStrut(10), p, gbl, gbc, 
         2, 1, 1, 1, 0, 0);
      addComp(transTF, p, gbl, gbc, 2, 2, 1, 1, 0, 0);
   
      return p;
   }

   /**
    * Utility method for adding components to a container using
    * grid bag layout constraints.
    *
    * @param comp the component being added.
    * @param cont the container we're adding to.
    * @param gbl the layout manager.
    * @param gbc the layout manager's constraints object.
    * @param row the row we're positioning in.
    * @param col the column we're positioning in.
    * @param numRows the number of rows this component is to span.
    * @param numCols the number of columns this component is to span.
    * @param weightx horizontal resize weight.
    * @param weighty horizontal resize weight.
    */
   private void addComp(Component comp, Container cont, GridBagLayout gbl,
      GridBagConstraints gbc, int row, int col, int numRows, int numCols,
      double weightx, double weighty)
   {  gbc.gridx = col;
      gbc.gridy = row;
      gbc.gridwidth = numCols;
      gbc.gridheight = numRows;
      gbc.weightx = weightx;
      gbc.weighty = weighty;

      cont.add(comp, gbc);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Till till;

   private JLabel priceLbl;
   private JTextField priceTF;
   private JLabel owedLbl;
   private JTextField owedTF;

   private JLabel floatLbl;
   private JTextField floatTF;
   private JLabel tillTotalLbl;
   private JTextField tillTotalTF;
   private JLabel transLbl;
   private JTextField transTF;

   private static final int TF_WIDTH = 10;

   private static final Color BACK_COLOUR = Color.white;
   private static final Color FORE_COLOUR = new Color(255, 0, 153);
}


