package web;

import java.net.*;
import java.io.*;
import utilities.PreconditionException;

/**
 * Objects of this class are URLs with a page source download
 * facility.
 * @author Derek Bridge
 */

public class URLDownLoader
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new URL downloader object.
    *
    * @param theURL the URL from which we will download; must be non-null.
    */
   public URLDownLoader(final URL theURL)
   {  if (theURL == null)
      {  throw new PreconditionException(
            "URLDownLoader Constructor Precondition Error: invalid URL: " +
            theURL);
      }

      url = theURL;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Downloads the web content from this URL. The content is
    * written to the specified print stream (typically System.out).
    *
    * @param thePrintStream the stream to which this URL's content
    * will be written; must be non-null.
    * @exception DownLoadException if a connection for dowloading cannot
    * be made.
    */
   public void download(PrintStream thePrintStream) throws DownLoadException
   {  if (thePrintStream == null)
      {  throw new PreconditionException(
            "URLDownLoader.download Precondition Error: invalid " +
            "print stream: " + thePrintStream);
      }

      BufferedReader stream = null;
      try
      {  /* Open stream.
          */
         stream = new BufferedReader(new InputStreamReader(url.openStream()));
         /* Read each String from the file and write it to the specified
            print stream.
          */
         boolean isEOF = false;
         do
         {  String nextString = stream.readLine();
            if (nextString == null)
            {  isEOF = true;
            }
            else
            {  thePrintStream.println(nextString);
            }
         } while (! isEOF);
      }
      catch (IOException e)
      {  throw new DownLoadException();
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/   
  
   private URL url; // the URL from which content will be downloaded.
}
