import consoleIO.*;
import java.io.IOException;
import utilities.Command;

/**
 * This class demonstrates the flexibility we get once we decouple
 * the user interface from the actions.
 * @author Derek Bridge
 */
public class MenuExample2
{
   public static void main(String[] args) throws Exception
   {  ConsoleMenu m = new ConsoleMenu(
        "Menu demo 2", "What? ");
      m.addItem(new ConsoleMenuItem(
         "Do action A", 
         new CommSubA()));
      m.addItem(new ConsoleMenuItem(
         "Do action B", 
         new CommSubB()));
      m.addItem(new ConsoleMenuItem(
         "Do action C", 
         new CommSubC()));
      m.addItem(new ConsoleMenuItem(
         "Do action D", 
         new CommSubD()));
      m.show();

      // All we need now is...
      m.invokeChosenItem();
   }

}
