import consoleIO.*;
import java.io.IOException;

/**
 * This class demonstrates the inflexibility of one way of writing
 * menu-driven systems. Specifically, the program's `knowledge' of
 * what processing corresponds to what user choice is hard-coded
 * into the program.
 * @author Derek Bridge
 */
public class MenuExample1
{
   public static void main(String[] args) throws IOException
   {  ConsoleMenu m = new ConsoleMenu(
        "Menu demo 1", "Gimme a choice: ");
      m.addItem(new ConsoleMenuItem(
         "Do action A", 
         new CommSubA()));
      m.addItem(new ConsoleMenuItem(
         "Do action B", 
         new CommSubB()));
      m.addItem(new ConsoleMenuItem(
         "Do action C", 
         new CommSubC()));
      m.addItem(new ConsoleMenuItem(
         "Do action D", 
         new CommSubD()));
      m.show();
      int usersChoice = m.getChosenItemNum();

      // Hard-coding the corresponding processing...
      switch (usersChoice)
      {  case 0 :
         {  doA();
            break;
         }
         case 1 :
         {  doB();
            break;
         }
         case 2 :
         {  doC();
            break;
         }
         case 3 :
         {  doD();
            break;
         }
         default : // Can't happen since choices are validated
         {  System.exit(1);
         }
      }
   }

   private static void doA()
   {  System.out.println("Doing A");
   }

   private static void doB()
   {  System.out.println("Doing B");
   }

   private static void doC()
   {  System.out.println("Doing C");
   }

   private static void doD()
   {  System.out.println("Doing D");
   }
}
