import java.util.*;

/**
 * A program that demonstrates some searches.
 * @author Derek Bridge
 */
public class SearchDemos
{
   public static void main(String[] args)
   {  StateSpaceSearch sss = null;

      System.out.println("Searches for the 8-puzzle.");
      int[][] startTiles = {{2, 8, 3}, {1, 6, 4}, {7, 0, 5}};
      EightPuzzleState start8P = new EightPuzzleState(
         startTiles, 2, 1);
      System.out.println("Breadth-first searches.");
      System.out.println("Allowing re-exploration.");
      sss = new StateSpaceSearch(start8P);
      printPath(sss.breadthFirstSearch());
      System.out.println("Avoiding undos.");
      sss = new StateSpaceSearchWithNoUndos(start8P);
      printPath(sss.breadthFirstSearch());
      System.out.println("Avoiding cycles.");
      sss = new StateSpaceSearchWithNoCycles(start8P);
      printPath(sss.breadthFirstSearch());

      System.out.println("Searches for the water jugs problem.");
      WaterJugsState startWJ = new WaterJugsState(0, 0);
      System.out.println("Depth-first searches.");
      // In this state space, there is much risk of infinite paths. 
      // So we only run searches that avoid cycles.
      System.out.println("Avoiding cycles.");
      sss = new StateSpaceSearchWithNoCycles(startWJ);
      printPath(sss.depthFirstSearch());
      System.out.println("Depth-bounded depth-first searches.");
      System.out.println("Allowing re-exploration, depth limit of 5.");
      sss = new StateSpaceSearch(startWJ);
      printPath(sss.depthBoundedSearch(5));
      System.out.println("Allowing re-exploration, depth limit of 6.");
      sss = new StateSpaceSearch(startWJ);
      printPath(sss.depthBoundedSearch(6));
      System.out.println(
         "Iterative-deepening depth-bounded depth-first searches.");
      System.out.println("Allowing re-exploration.");
      sss = new StateSpaceSearch(startWJ);
      printPath(sss.iterativeDeepeningSearch());
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/
   /**
    * Prints the action and states that lie along a solution path.
    * @param thePath a list of Nodes.
    */
   private static void printPath(List thePath)
   {  System.out.println("\nSolution path\n-------------");
      if (thePath == null)
      {  System.out.println("No solution");
      }
      else
      {  Iterator iter = thePath.iterator();
         while (iter.hasNext())
         {  Node next = (Node) iter.next();
            System.out.println(next.getAction());
            System.out.println(next.getState());
         }
         System.out.println();
      }
   }
}
