/**
 * A class that demonstrates the operation of a network of TLUs.
 * @author Derek Bridge
 */
public class NetDemo
{
   public static void main(String[] args)
   {  /* A fully-connected, multilayered, feedforward net of TLUs
         for computing exclusive-or. (The net has two layers.)
         There are 2 sensor inputs, 3 hidden units and 1 output unit.
         (This excludes the `extras' needed to translate thresholds into
         weights.)
       */
      TwoLayerNet net = new TwoLayerNet(2, 3, 1);
      net.setHiddenLayerWeight(0, 1, -1.5);
      net.setHiddenLayerWeight(1, 1, 1.0);
      net.setHiddenLayerWeight(2, 1, 1.0);
      net.setHiddenLayerWeight(0, 2, -0.5);
      net.setHiddenLayerWeight(1, 2, 1.0);
      net.setHiddenLayerWeight(2, 2, 0.0);
      net.setHiddenLayerWeight(0, 3, -0.5);
      net.setHiddenLayerWeight(1, 3, 0.0);
      net.setHiddenLayerWeight(2, 3, 1.0);
      net.setOutputLayerWeight(0, 0, -0.5);
      net.setOutputLayerWeight(1, 0, -2.0);
      net.setOutputLayerWeight(2, 0, 1.0);
      net.setOutputLayerWeight(3, 0, 1.0);

      System.out.println("XOR\n===");
      activateOn4Inputs(net);
   }

   private static void activateOn4Inputs(TwoLayerNet aNet)
   {  double[] inputs = new double[2];
      for (int i = 0; i < 2; i++)
      {  inputs[0] = i;
         for (int j = 0; j < 2; j++)
         {  inputs[1] = j;
            System.out.print(i + " " + j + ": ");
            double[] outputs = aNet.activate(inputs);
            System.out.println(outputs[0]);
         }
      }
      System.out.println();
   }
}
