package world;
import java.io.*;
import java.util.*;
import proplogic.*;
import actions.*;

/**
 * A class that represents stimulus-rseponse rules in a reflex agent.
 * @author Derek Bridge
 */
public class StimulusResponseRule
   implements Serializable
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new stimulus-response rule with the given
    * condition and action.
    * @param theConditon the rule's condition (a Boolean expression).
    * @param theAction the rule's action.
    */
   public StimulusResponseRule(BooleanExpression theCondition,
      Action theAction)
   {  condition = theCondition;
      action = theAction;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true iff the rule's condition is true in the valuation.
    */
   public boolean isSatisfied(Map valuation)
   {  return condition.getValue(valuation);
   }

   /**
    * Returns the action of this rule.
    */
   public Action getAction()
   {  return action;
   }

   /**
    * Returns a string representation of this rule.
    */
   public String toString()
   {  return "IF " + condition.toString() +
         " THEN " + action.toString();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   protected BooleanExpression condition;
   protected Action action;
}
