package world;

/**
 * A class that represents graphical agents that inhabit a grid-like world.
 * @author Derek Bridge
 */
public abstract class Agent
   extends PhysObject
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new agent.
    */
   public Agent()
   {
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public class constants-------------------------------------------- */

   public static final int RIGHT_SIDE = 0;
   public static final int FRONT_RIGHT = 1;
   public static final int FRONT = 2;
   public static final int FRONT_LEFT = 3;
   public static final int LEFT_SIDE = 4;
   public static final int BACK_LEFT = 5;
   public static final int BACK = 6;
   public static final int BACK_RIGHT = 7;

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the direction in which the agent is presently facing.
    */
   public int getDirection()
   {  return direction;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the agent's direction.
    * @param theDirection the new direction for the agent (one of
    * the compass points).
    */
   public void setDirection(int theDirection)
   {  direction = theDirection;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   protected int direction;
}
