package world;
import java.io.*;

/**
 * A class that represents actions that agents that inhabit grid-like
 * worlds can carry out.
 * @author Derek Bridge
 */
public abstract class Action
   implements Serializable
{   
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new action.
    */
   public Action()
   {
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Carry out the action in the world.
    * @param theAgent the agent who is executing the action.
    */
   public abstract void execute(Agent theAgent);
}
