package proplogic;
import java.util.*;

/**
 * A class that represents Boolean expressions that comprise a unary
 * operator applied to a Boolean expression.
 * @author Derek Bridge
 */
public abstract class UnaryBooleanExpression
   extends BooleanExpression
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a Boolean expression involving a unary operator.
    * @param theArgumentExpression the expression the unary operator
    * is being applied to.
    */
   public UnaryBooleanExpression(BooleanExpression theArgumentExpression)
   {  argumentExpression = theArgumentExpression;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   protected BooleanExpression argumentExpression;
}
