package proplogic;
import java.util.*;

/**
 * A class that represents propositional variables within Boolean 
 * expressions.
 * @author Derek Bridge
 */
public class Proposition
   extends Atom
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new propositional variable within a Boolean expression.
    * @paramn theName the variable's name.
    */
   public Proposition(String theName)
   {  name = theName;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the value of the propositonal variable according to the 
    * valuation.
    */
   public boolean getValue(Map valuation)
   {  Boolean value = (Boolean) valuation.get(name);
      return value.booleanValue();
   }

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return name;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private String name;
}
