package proplogic;
import java.util.*;

/**
 * A class that represents disjunctions of Boolean expressions.
 * @author Derek Bridge
 */
public class OR
   extends BinaryBooleanExpression
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new disjoined Boolean expression.
    * @param anArgumentExpression1 one expression being disjoined.
    * @param anArgumentExpression2 the other expression being disjoined.
    */
   public OR(BooleanExpression anArgumentExpression1,
      BooleanExpression anArgumentExpression2)
   {  super(anArgumentExpression1, anArgumentExpression2);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the vaue of the disjunction expression.
    */
   public boolean getValue(Map valuation)
   {  if (argumentExpression1.getValue(valuation))
      {  return true;
      }
      return argumentExpression2.getValue(valuation);
   }

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return "(" + argumentExpression1.toString() + " OR " +
         argumentExpression2.toString() + ")";
   }
}
