package proplogic;
import java.util.*;

/**
 * A class that represents conjunctions of Boolean expressions.
 * @author Derek Bridge
 */
public class AND
   extends BinaryBooleanExpression
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new conjoined Boolean expression.
    * @param anArgumentExpression1 one expression being conjoined.
    * @param anArgumentExpression2 the other expression being conjoined.
    */
   public AND(BooleanExpression anArgumentExpression1,
      BooleanExpression anArgumentExpression2)
   {  super(anArgumentExpression1, anArgumentExpression2);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the vaue of the conjunction expression.
    */
   public boolean getValue(Map valuation)
   {  if (! argumentExpression1.getValue(valuation))
      {  return false;
      }
      return argumentExpression2.getValue(valuation);
   }

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return "(" + argumentExpression1.toString() + " AND " +
         argumentExpression2.toString() + ")";
   }
}
