package nets;

/**
 * An abstract class that represents threshold logic units (TLUs).
 * These are for use in fully-connected, two-layered, feedforward
 * networks.
 * @author Derek Bridge
 */
public abstract class TLU
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new TLU with the given number of inputs and weights. 
    * (The length of the weight array should equal theNumOfInputs.)
    * @param theNumOfInputs the number of inputs (i.e. the number
    * of sensors supplying input to this TLU or the number of other
    * TLUs supplying input to this TLU, including `extras'.).
    * @param theWeights the weights.
    */
   public TLU(int theNumOfInputs, double[] theWeights)
   {  numOfInputs = theNumOfInputs;
      inputs = new double[numOfInputs];
      weights = theWeights;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the cached value of this TLU's output.
    * The code assumes that the programmer will not invoke this method
    * unless s/he has previously activated the TLU so that there is a
    * cached value.
    */
   public double getOutput()
   {  return output;
   }

   /**
    * Returns the gradient at the most recent input level.
    */
   public double getGradient()
   {  return gradient;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   protected int numOfInputs;
   protected double[] weights;

   /* When a TLU is activated, the array called inputs, the 
      variable called outputs and the variable called gradient
      will be used to cached the input, output and gradient
      values for that activation. It turns out that
      doing this is both convenient and also improves the
      the run-time efficiency of the learning algorithm.
    */
   protected double[] inputs;
   protected double output;
   protected double gradient;
}
