package gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import world.*;

/**
 * A class that represents menu bars for grid-like world displays.
 * @author Derek Bridge
 */
public class WorldMenuBar
   extends JMenuBar
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new menu bar.
    * @param theParent the parent component (dialogs will be centred
    * within its parent).
    * @param theWorld the world.
    * @param menuEventListener listener for menu posting.
    * @param menuItemEventListener listener for menu items.
    */
   public WorldMenuBar(Component theParent, World theWorld,
      MenuListener menuEventListener, ActionListener menuItemEventListener)
   {  fileMenu = new JMenu("File");
      fileMenu.setMnemonic('F');
      fileMenu.addMenuListener(menuEventListener);
      newButton = new JMenuItem("New");
      newButton.setActionCommand("new");
      newButton.addActionListener(menuItemEventListener);
      newButton.setMnemonic('N');
      newButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_N, Event.CTRL_MASK));
      fileMenu.add(newButton);
      openButton = new JMenuItem("Open");
      openButton.setActionCommand("open");
      openButton.addActionListener(menuItemEventListener);
      openButton.setMnemonic('O');
      openButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_O, Event.CTRL_MASK));
      fileMenu.add(openButton);
      saveButton = new JMenuItem("Save");
      saveButton.setActionCommand("save");
      saveButton.addActionListener(menuItemEventListener);
      saveButton.setMnemonic('S');
      saveButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_S, Event.CTRL_MASK));
      fileMenu.add(saveButton);
      fileMenu.addSeparator();
      exitButton = new JMenuItem("Exit");
      exitButton.setActionCommand("exit");
      exitButton.addActionListener(menuItemEventListener);
      exitButton.setMnemonic('X');
      exitButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_X, Event.CTRL_MASK));
      fileMenu.add(exitButton);
      add(fileMenu);

      runMenu = new JMenu("Run");
      runMenu.setMnemonic('R');
      runMenu.addMenuListener(menuEventListener);
      startButton = new JMenuItem("Start");
      startButton.setActionCommand("start");
      startButton.addActionListener(menuItemEventListener);
      startButton.setMnemonic('T');
      startButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_T, Event.CTRL_MASK));
      runMenu.add(startButton);
      stopButton = new JMenuItem("Stop");
      stopButton.setActionCommand("stop");
      stopButton.addActionListener(menuItemEventListener);
      stopButton.setMnemonic('P');
      stopButton.setAccelerator(
         KeyStroke.getKeyStroke(KeyEvent.VK_P, Event.CTRL_MASK));
      runMenu.add(stopButton);
      setSpeedButton = new JMenuItem("Speed");
      setSpeedButton.setActionCommand("speed");
      setSpeedButton.addActionListener(menuItemEventListener);
      setSpeedButton.setMnemonic('D');
      runMenu.add(setSpeedButton);
      add(runMenu);

      configMenu = new JMenu("Setup");
      configMenu.setMnemonic('S');
      configMenu.addMenuListener(menuEventListener);
      gridLinesVisibleButton = new JRadioButtonMenuItem("Gridlines visible");
      gridLinesVisibleButton.setActionCommand("gridLines");
      gridLinesVisibleButton.addActionListener(menuItemEventListener);
      gridLinesVisibleButton.setMnemonic('G');
      configMenu.add(gridLinesVisibleButton);
      smellVisibleButton = new JRadioButtonMenuItem("Smells visible");
      smellVisibleButton.setActionCommand("smell");
      smellVisibleButton.addActionListener(menuItemEventListener);
      smellVisibleButton.setMnemonic('M');
      configMenu.add(smellVisibleButton);
      lightVisibleButton = new JRadioButtonMenuItem("Light visible");
      lightVisibleButton.setActionCommand("light");
      lightVisibleButton.addActionListener(menuItemEventListener);
      lightVisibleButton.setMnemonic('L');
      configMenu.add(lightVisibleButton);
      createObjMenu = new ObjectCreationMenu(theParent, theWorld).
         getPullRightMenu();
      configMenu.add(createObjMenu);
      add(configMenu);

      helpMenu = new JMenu("Help");
      helpMenu.setMnemonic('H');
      aboutButton = new JMenuItem("About");
      aboutButton.setActionCommand("about");
      aboutButton.addActionListener(menuItemEventListener);
      aboutButton.setMnemonic('A');
      helpMenu.add(aboutButton);
      // setHelpMenu(helpMenu); doesn't work in Java yet
      add(helpMenu);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Enables options that are only enabled when simulation is stoppped.
    */
   public void enableOptions()
   {  newButton.setEnabled(true);
      openButton.setEnabled(true);
      saveButton.setEnabled(true);
      gridLinesVisibleButton.setEnabled(true);
      smellVisibleButton.setEnabled(true);
      lightVisibleButton.setEnabled(true);
      createObjMenu.setEnabled(true);
   }

   /**
    * Disables options that are disabled when simulation is running.
    */
   public void disableOptions()
   {  newButton.setEnabled(false);
      openButton.setEnabled(false);
      saveButton.setEnabled(false);
      gridLinesVisibleButton.setEnabled(false);
      smellVisibleButton.setEnabled(false);
      lightVisibleButton.setEnabled(false);
      createObjMenu.setEnabled(false);
   }

   /**
    * Sets the toggle status of the gridlines visible button.
    * @param theStatus the new status.
    */
    public void toggleGridLinesVisible(boolean theStatus)
    {  gridLinesVisibleButton.setSelected(theStatus);
    }

   /**
    * Sets the toggle status of the smell visible button.
    * @param theStatus the new status.
    */
    public void toggleSmellVisible(boolean theStatus)
    {  smellVisibleButton.setSelected(theStatus);
    }

   /**
    * Sets the toggle status of the light visible button.
    * @param theStatus the new status.
    */
    public void toggleLightVisible(boolean theStatus)
    {  lightVisibleButton.setSelected(theStatus);
    }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private JMenu fileMenu;
   private JMenuItem newButton;
   private JMenuItem openButton;
   private JMenuItem saveButton;
   private JMenuItem exitButton;

   private JMenu runMenu;
   private JMenuItem startButton;
   private JMenuItem stopButton;
   private JMenuItem setSpeedButton;

   private JMenu configMenu;
   private JRadioButtonMenuItem gridLinesVisibleButton;
   private JRadioButtonMenuItem smellVisibleButton;
   private JRadioButtonMenuItem lightVisibleButton;
   private JMenu createObjMenu;
   private JMenuItem brickButton;
   private JMenuItem flittingLightButton;
   private JMenuItem lightSeekerButton;
   private JMenuItem wallFollowerButton;

   private JMenu helpMenu;
   private JMenuItem aboutButton;
}
