package gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 * A class that represents dialogs for setting the simulation speed.
 * @author Derek Bridge
 */
public class SpeedDialog
   extends JDialog
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new dialog for setting the simulation speed.
    * @param theParent the parent component (this dialog will be centred
    * within its parent).
    * @param theController the world controller.
    */
    public SpeedDialog(Component theParent, WorldController theWorldController)
   {  super();
      parent = theParent;
      worldController = theWorldController;
      setTitle("Speed");
      JPanel dialogPanel = new JPanel();
      JLabel textLbl = new JLabel("Please set the new speed");
      slider = new JSlider(JSlider.HORIZONTAL, MINIMUM, MAXIMUM,
         MAXIMUM - worldController.getInterval());
      okBtn = new JButton("OK");
      okBtn.setActionCommand("ok");
      okBtn.addActionListener(this);
      cancelBtn = new JButton("Cancel");
      cancelBtn.setActionCommand("cancel");
      cancelBtn.addActionListener(this);
      GridBagLayout gbl = new GridBagLayout();
      GridBagConstraints gbc = new GridBagConstraints();
      dialogPanel.setLayout(gbl);     
      gbc.fill = GridBagConstraints.BOTH;
      gbc.anchor = GridBagConstraints.CENTER;
      GuiUtility.addComp(textLbl, dialogPanel, gbl, gbc, 0, 0, 1, 2, 1, 1);
      GuiUtility.addComp(slider, dialogPanel, gbl, gbc, 1, 0, 1, 2, 1, 1);
      GuiUtility.addComp(okBtn, dialogPanel, gbl, gbc, 2, 0, 1, 1, 1, 1);
      GuiUtility.addComp(cancelBtn, dialogPanel, gbl, gbc, 2, 1, 1, 1, 1, 1); 
      getContentPane().add(dialogPanel);
      pack();
   }

   /**
    * Makes this dialog visible, centred within its parent.
    * @param status whether to make it visible or invisible.
    */
   public void setVisible(boolean status)
   {  if (status)
      {  Point parentLocation = parent.getLocationOnScreen();
         Dimension parentSize = parent.getSize();
         Point point = new Point();
         Dimension size = getSize();  
         point.x = parentLocation.x + ((parentSize.width - size.width) / 2);
         point.y = parentLocation.y + ((parentSize.height - size.height) / 2);
         setLocation(point);
      }
      super.setVisible(status);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Responds to the user clicking either button in this dialog.
    */
   public void actionPerformed(ActionEvent ae)
   {  setVisible(false);
      String command = ae.getActionCommand();
      if (command.equals("ok"))
      {  if (! slider.getValueIsAdjusting())
         {  worldController.setInterval(MAXIMUM - slider.getValue());
         }
      }
      else
      {  slider.setValue(MAXIMUM - worldController.getInterval());
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Component parent;
   private WorldController worldController;
   private JSlider slider;
   private JButton okBtn;
   private JButton cancelBtn;

   private static final int MINIMUM = 0;
   private static final int MAXIMUM = 500;
}
