package gui;
import java.io.*;

/**
 * A class that represents file filters for file choosers.
 * @author Derek Bridge
 */
public class ExtensionFileFilter
   extends javax.swing.filechooser.FileFilter
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new file filter with the given file extension
    * @param theExtension the file extension.
    * @param theDescription the description of files with this extension
    */
   public ExtensionFileFilter(String theExtension, String theDescription)
   {  extension = theExtension;
      description = theDescription;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns whether a file satisfies the filter.
    */
   public boolean accept(File theFile)
   {  return theFile.isDirectory() || theFile.getName().endsWith("." + extension);
   }

   /**
    * Returns the description.
    */
   public String getDescription()
   {  return description;
   }

   /**
    * Adds an extension to a file name, if necessary.
    * @param theFileName the original file name.
    */
   public String addExtension(String theFileName)
   {  if (new File(theFileName).isDirectory() || theFileName.endsWith("." + extension))
      {  return theFileName;
      }
      else
      {  return theFileName + "." + extension;
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private String extension;
   private String description;
}
