package gui;
import java.awt.*;
import world.*;

/**
 * A class that represents Gui components typically for bricks in grid-like 
 * worlds.
 * @author Derek Bridge
 */
public class BlockGraphic
   extends PhysObjectGraphic
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new Gui block component for a given physical object.
    * @param theObject the object whose Gui component we are creating.
    */
   public BlockGraphic(PhysObject theObject)
   {  super(theObject);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Draws this component on the graphics context at the given position.
    */
   public void draw(Graphics g, int x, int y)
   {  g.setColor(colour);
      g.fillRect(x, y, 1, 1);
   }
}
