package ga;
import java.util.*;

/**
 * An interface that defines what it means to be an evolvable agent.
 * @author Derek Bridge
 */
public interface IGAAgent
   extends Cloneable
{
   /**
    * Returns the fitness of this agent.
    */
   public float getFitness();

   /**
    * Returns the genes of this agent.
    */
   public String getGenes();

   /**
    * Sets the fitness of this agent.
    * @param theFitness the fitness of this agent.
    */
   public void setFitness(float theFitness);

   /**
    * Sets the genes of this agent.
    *  @param theGenes the genes of this agent.
    */
   public void setGenes(String theGenes);

   public Object clone();

   /**
    * Returns a mutated version of this agent.
    */
   public IGAAgent createMutatedChild();

   /**
    * Returns the children formed by combining this agent with the
    * give agent.
    * @param theMate the agent with whom this agent is mating.
    * @return a list containing TWO children.
    */
   public List createCombinedChildren(IGAAgent theMate);
}
