package demos;
import java.util.*;
import world.*;
import gui.*;

/**
 * A class that runs the demonstrator using a world that contains an outer 
 * and inner wall and a wall following agent.
 * @author Derek Bridge
 */
public class WallFollowerMain
{
   public static void main(String[] args)
   {  World world = new WalledWorld(16, 13, 20)
      {  public List createObjects()
         {  List objects = new LinkedList();
            objects = buildHorizontalWall(0, 0, 15, objects);
            objects = buildHorizontalWall(1, 13, 15, objects);
            objects = buildHorizontalWall(2, 13, 15, objects);
            objects = buildHorizontalWall(3, 13, 15, objects);
            objects = buildHorizontalWall(4, 13, 15, objects);
            objects = buildVerticalWall(15, 5, 8, objects);
            objects = buildHorizontalWall(8, 12, 15, objects);
            objects = buildHorizontalWall(9, 12, 15, objects);
            objects = buildHorizontalWall(10, 12, 15, objects);
            objects = buildHorizontalWall(11, 12, 15, objects);
            objects = buildHorizontalWall(12, 0, 15, objects);
            objects = buildHorizontalWall(10, 6, 8, objects);
            objects = buildHorizontalWall(11, 6, 8, objects);
            objects = buildVerticalWall(0, 0, 11, objects);
            objects = buildHorizontalWall(5, 3, 8, objects);
            objects = buildHorizontalWall(6, 3, 4, objects);
            objects = buildHorizontalWall(6, 7, 8, objects);
            objects = buildHorizontalWall(7, 3, 4, objects);
            objects = buildHorizontalWall(7, 7, 8, objects);
            return objects;
         }
      };
      WorldController controller = new WorldController(world);
   }
}
