package demos;
import world.*;
import gui.*;
import proplogic.*;
import actions.*;

/**
 * A class of agents that inhabit grid-like world and follow walls.
 * @author Derek Bridge
 */
public class PSWallFollowingAgent
   extends ProductionSystemAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new wall-following agent.
    */
   public PSWallFollowingAgent()
   {  for (int i = 0; i < World.NUM_OF_COMPASS_POINTS; i++)
      {  hasTouchSensor[i] = true;
      }
      physObjectGraphic = new PacmanGraphic(this);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Creates this agent's production system.
    */
   public ProductionSystem createRules()
   {  ProductionSystem rules = new ProductionSystem();
      StimulusResponseRule r0 = 
         new StimulusResponseRule(
            new AND(new NOT(new Proposition("p0")), 
                    new Proposition("p2")),
            new Move());
      StimulusResponseRule r1 = 
         new StimulusResponseRule(
            new AND(new NOT(new Proposition("p2")), 
                    new Proposition("p3")),
           new Turn(Turn.RIGHT, 2));
      StimulusResponseRule r2 = 
         new StimulusResponseRule(
            new Proposition("p0"),
            new Turn(Turn.LEFT, 2));
      StimulusResponseRule r3 =
         new StimulusResponseRule(
            new True(),
            new Move());
      rules.addRule(r0);
      rules.addRule(r1);
      rules.addRule(r2);
      rules.addRule(r3);
      return rules;
   }

   /**
    * Convert the sensor readings into propositions.
    */
   public void preprocess()
   {  /* This agent has 7 sensors.
         In fact, the rules only make use of three of them:
         p0, p2 and p3.
       */
      Boolean p0Value = FALSE; // front
      Boolean p1Value = FALSE; // front right
      Boolean p2Value = FALSE; // right side
      Boolean p3Value = FALSE; // back right
      Boolean p4Value = FALSE; // back 
      Boolean p5Value = FALSE; // back left
      Boolean p6Value = FALSE; // left
      Boolean p7Value = FALSE; // front left
      if (touchReading[FRONT])
      {  p0Value = TRUE;
      }
      if (touchReading[FRONT_RIGHT])
      {  p1Value = TRUE;
      }
      if (touchReading[RIGHT_SIDE])
      {  p2Value = TRUE;
      }
      if (touchReading[BACK_RIGHT])
      {  p3Value = TRUE;
      }
      if (touchReading[BACK])
      {  p4Value = TRUE;
      }
      if (touchReading[BACK_LEFT])
      {  p5Value = TRUE;
      }
      if (touchReading[LEFT_SIDE])
      {  p6Value = TRUE;
      }
      if (touchReading[FRONT_LEFT])
      {  p7Value = TRUE;
      }
      propositions.put("p0", p0Value);
      propositions.put("p1", p1Value);
      propositions.put("p2", p2Value);
      propositions.put("p3", p3Value);
      propositions.put("p4", p4Value);
      propositions.put("p5", p5Value);
      propositions.put("p6", p6Value);
      propositions.put("p7", p7Value);
   }
}

