package demos;
import java.util.*;
import nets.*;
import world.*;
import gui.*;

/**
 * A hacked-up class that trains a neural net using wall follower data
 * and then demonstrates an agent that uses this net for its action function.
 * @author Derek Bridge
 */
public class NeuralWallFollowerMain
{
   public static void main(String[] args)
   {  Map trainingSet = LearningUtilities.readExamples(
         "demos/wallFollower.data", // file name
         8,           // number of input attributes
         2            // number of output attributes
         );
      BackProp bp = new BackProp(
         8, // number of input units
         3, // number of hidden units
         2  // number of output units
         );
      TwoLayerNet net = bp.backProp(
         0.1, // allowable error
         0.35, // the learning rate
         trainingSet, 
         1,    // how much output we want (1 = start and final nets)
         null, // test set (no test set)
         0     // how often to test the net (0 = not at all)
         );
      Agent agent = new NeuralWallFollowingAgent(net);
      // demo the evolved agent
      World world = new WalledWorld(16, 13, 20)
      {  public List createObjects()
         {  List objects = new LinkedList();
            objects = buildHorizontalWall(0, 0, 15, objects);
            objects = buildHorizontalWall(1, 12, 15, objects);
            objects = buildHorizontalWall(2, 12, 15, objects);
            objects = buildHorizontalWall(3, 12, 15, objects);
            objects = buildHorizontalWall(4, 12, 15, objects);
            objects = buildVerticalWall(15, 5, 7, objects);
            objects = buildHorizontalWall(8, 12, 15, objects);
            objects = buildHorizontalWall(9, 12, 15, objects);
            objects = buildHorizontalWall(10, 12, 15, objects);
            objects = buildHorizontalWall(11, 12, 15, objects);
            objects = buildVerticalWall(0, 0, 12, objects);
            objects = buildHorizontalWall(12, 1, 5, objects);
            objects = buildVerticalWall(6, 10, 12, objects);
            objects = buildVerticalWall(7, 10, 12, objects);
            objects = buildVerticalWall(8, 10, 12, objects);
            objects = buildHorizontalWall(12, 9, 15, objects);
            objects = buildHorizontalWall(3, 3, 6, objects);
            objects = buildHorizontalWall(6, 1, 6, objects);
            objects = buildVerticalWall(6, 4, 5, objects);
            return objects;
         }
      };
      WorldController controller = new WorldController(world);
      // place the agent randomly
      while (true)
      {  int x = 0;
         int y = 0;
         do
         {  x = (int) (Math.random() * world.getWorldWidth());
            y = (int) (Math.random() * world.getWorldHeight());
         } while (! world.getCells()[x][y].canAccommodate(agent));
         agent.setCell(world.getCells()[x][y]);
         world.getCells()[x][y].addObject(agent);
         world.getObjects().add(agent); 
         // the agent orientation is also random (but I only E, N, W or S!)
         int randomDir = ((int) (Math.random() * World.NUM_OF_COMPASS_POINTS / 2) * 2);
         agent.setDirection(randomDir);
         controller.setWorld(world);
         // run the simulation for 30 seconds
         controller.startClock();
         try
         {  Thread.sleep(30000);
         }
         catch (InterruptedException ie) 
         {
         }
         controller.stopClock();
         // pause before repeating the demo
         try
         {  Thread.sleep(5000);
         }
         catch (InterruptedException ie) 
         {
         }
         agent.getCell().removeObject(agent);
         world.getObjects().remove(agent);
      }        
   }
}
