package demos;
import ga.*;
import world.*;
import actions.*;
import gui.*;

/**
 * A class of agents that inhabit grid-like world and that we evolve so
 * that they follow walls.
 * @author Derek Bridge
 */
public class GAWallFollowingAgent
   extends GAProductionSystemAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new evolvable wall-following agent.
    */
   public GAWallFollowingAgent()
   {  /* There are 8 propositions in total.
         We will tell the evolution about only 4 actions; we need 2 bits to 
         encode 4 actions.
         We will allow only 4 rules.
       */
      super(3, 2, 4);
      String[] props = {"p0", "p2", "p3"};
      Action[] acts = {new Move(), new Turn(Turn.RIGHT, 2), 
         new Turn(Turn.LEFT, 2), new NullAction()};
      setDecodeInfo(props, acts);
      for (int i = 0; i < World.NUM_OF_COMPASS_POINTS; i++)
      {  hasTouchSensor[i] = true;
      }
      physObjectGraphic = new PacmanGraphic(this);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Create offspring by copying this agent.
    */
   public Object clone()
   {  GAWallFollowingAgent agent = (GAWallFollowingAgent) super.clone();
      agent.physObjectGraphic = new PacmanGraphic(agent);
      return agent;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Convert the sensor readings into propositions.
    */
   public void preprocess()
   {  // For speedy evolution, we're using only 3 propositions
      Boolean p0Value = FALSE; // front.
//    Boolean p1Value = FALSE; // front right
      Boolean p2Value = FALSE; // right side
      Boolean p3Value = FALSE; // back right
//    Boolean p4Value = FALSE; // back
//    Boolean p5Value = FALSE; // back left
//    Boolean p6Value = FALSE; // left side
//    Boolean p7Value = FALSE; // front left
      if (touchReading[FRONT])
      {  p0Value = TRUE;
      }
//    if (touchReading[FRONT_RIGHT])
//    {  p1Value = TRUE;
//    }
      if (touchReading[RIGHT_SIDE])
      {  p2Value = TRUE;
      }
      if (touchReading[BACK_RIGHT])   
      {  p3Value = TRUE;
      }
//    if (touchReading[BACK])
//    {  p4Value = TRUE;
//    }
//    if (touchReading[BACK_LEFT])   
//    {  p5Value = TRUE;
//    }
//    if (touchReading[LEFT_SIDE])
//    {  p6Value = TRUE;
//    }
//    if (touchReading[FRONT_LEFT])
//    {  p7Value = TRUE;
//    }
      propositions.put("p0", p0Value);
//    propositions.put("p1", p1Value);
      propositions.put("p2", p2Value);
      propositions.put("p3", p3Value);
//    propositions.put("p4", p4Value);
//    propositions.put("p5", p5Value);  
//    propositions.put("p6", p6Value);
//    propositions.put("p7", p7Value);
   }
}

