package demos;
import javax.swing.*;
import ga.*;
import world.*;
import gui.*;

/**
 * A hacked-up class that runs the evolution demonstrator to evolve a wall
 * following agent and then to demonstrate that agent.
 * @author Derek Bridge
 */
public class GAWallFollowerMain
{
   public static void main(String[] args)
   {  try
      {  if (args.length < 6 || args.length > 6)
         {  throw new NumberFormatException();
         }
         int popSize = Integer.parseInt(args[0]);
         int tournSize = Integer.parseInt(args[1]);
         float combining = Float.parseFloat(args[2]);
         float mutating = Float.parseFloat(args[3]);
         float copying = Float.parseFloat(args[4]);
         int numGens = Integer.parseInt(args[5]);
         if (popSize < 1 || tournSize < 1 || tournSize > popSize ||
            combining < 0.0f || combining > 1.0f ||
            mutating < 0.0f || mutating > 1.0f ||
            copying < 0.0f || mutating > 1.0f ||
            (combining + mutating + copying) > 1.0f ||
            numGens < 0)
         {  throw new NumberFormatException();
         }
         JFrame frame = new JFrame("Evolutionary Progress");
         JTextArea outputArea = new JTextArea(20, 35);
         frame.getContentPane().add(new JScrollPane(outputArea));
         frame.setLocation(600, 200);
         frame.pack();
         frame.setVisible(true);
         StringBuffer output = new StringBuffer();
         IGAFactory factory = new GAWallFollowerFactory();
         GeneticAlgorithm ga = new GeneticAlgorithm(factory, 
            popSize, tournSize, combining, mutating, copying);
         IGAAgent gaAgent = ga.getBestAgentInPopulation();
         output.append("Generation 0\n" +
            "Best agent fitness: " + gaAgent.getFitness() + "\n" + gaAgent + "\n\n\n");           
         outputArea.setText(output.toString());
         for (int i = 1; i <= numGens; i++)
         {  ga.evolve();
            gaAgent = ga.getBestAgentInPopulation();
            output.append("Generation " + i + "\n" +
               "Best agent fitness: " + gaAgent.getFitness() + "\n" + gaAgent + "\n\n\n");
            outputArea.setText(output.toString());
         }
         // demo the evolved agent
         World world = (World) new GAWallFollowerFactory().createWorld();
         WorldController controller = new WorldController(world);
         Agent agent = (Agent) gaAgent;
         // place the agent randomly
         while (true)
         {  int x = 0;
            int y = 0;
            do
            {  x = (int) (Math.random() * world.getWorldWidth());
               y = (int) (Math.random() * world.getWorldHeight());
            } while (! world.getCells()[x][y].canAccommodate(agent));
            agent.setCell(world.getCells()[x][y]);
            world.getCells()[x][y].addObject(agent);
            world.getObjects().add(agent); 
            // the agent orientation is also random (but I only E, N, W or S!)
            int randomDir = ((int) (Math.random() * World.NUM_OF_COMPASS_POINTS / 2) * 2);
            agent.setDirection(randomDir);
            controller.setWorld(world);
            // run the simulation for 30 seconds
            controller.startClock();
            try
            {  Thread.sleep(30000);
            }
            catch (InterruptedException ie) 
            {
            }
            controller.stopClock();
            // pause before repeating the demo
            try
            {  Thread.sleep(5000);
            }
            catch (InterruptedException ie) 
            {
            }
            agent.getCell().removeObject(agent);
            world.getObjects().remove(agent);
         }        
      }
      catch (NumberFormatException nfe)
      {  System.err.println(
           "java GAWallFollowerMain int1 int2 float1 float2 float3 int3\n\n" +
           "int1, the population size, should be a positive whole number.\n" +
           "int2, the tournament size, should be a positive whole number\n" +
           "      smaller than the population size.\n" +
           "float1, float2 & float3, the combining, mutation and copying\n" +
           "      proportions, should be real numbers, greater than zero,\n" +
           "      and summing to one.\n" +
           "int3, the number of generations, should be a whole number,\n" +
           "      greater than or equal to zero.");
      }  
   }
}
