package demos;
import java.util.*;
import world.*;
import ga.*;

/**
 * A factory class for supplying a walled world and wall following agents
 * to a generic genetic algorithm.
 * @author Derek Bridge
 */
public class GAWallFollowerFactory
   implements IGAFactory
{
   /**
    * Returns a world of an appropriate kind in which evolved agents
    * will be tested.
    */
   public IGAWorld createWorld()
   {  return new GAWalledWorld(16, 13, 20)
      {  public List createObjects()
         {  List objects = new LinkedList();
            monitors = new LinkedList();
            objects = buildHorizontalWall(0, 0, 15, objects);
            objects = buildHorizontalWall(1, 12, 15, objects);
            objects = buildHorizontalWall(2, 12, 15, objects);
            objects = buildHorizontalWall(3, 12, 15, objects);
            objects = buildHorizontalWall(4, 12, 15, objects);
            objects = buildVerticalWall(15, 5, 7, objects);
            objects = buildHorizontalWall(8, 12, 15, objects);
            objects = buildHorizontalWall(9, 12, 15, objects);
            objects = buildHorizontalWall(10, 12, 15, objects);
            objects = buildHorizontalWall(11, 12, 15, objects);
            objects = buildVerticalWall(0, 0, 12, objects);
            objects = buildHorizontalWall(12, 1, 5, objects);
            objects = buildVerticalWall(6, 10, 12, objects);
            objects = buildVerticalWall(7, 10, 12, objects);
            objects = buildVerticalWall(8, 10, 12, objects);
            objects = buildHorizontalWall(12, 9, 15, objects);
            objects = buildHorizontalWall(3, 3, 6, objects);
            objects = buildHorizontalWall(6, 1, 6, objects);
            objects = buildVerticalWall(6, 4, 5, objects);
            for (int x = 0; x < width; x++)
            {  for (int y = 0; y < height; y++)
               {  if (cells[x][y].isEmpty())
                  {  boolean isBesideWall = false;
                     for (int k = 0; k < NUM_OF_COMPASS_POINTS; k++)
                     {  Cell c = cells[x][y].getNeighbour(k);
                        if (c.someSpaceIsInUse())
                        {  isBesideWall = true;
                           break;
                        }
                     }
                     if (isBesideWall)
                     {  CellMonitorAgent cm = new CellMonitorAgent();
                        cm.setCell(cells[x][y]);
                        cells[x][y].addObject(cm);
                        objects.add(cm);
                        monitors.add(cm);
                     }
                  }
               }
            }
            return objects;
         }
      };
   }


   /**
    * Returns an agent of an appropriate kind (typically a randomly
    * generated agent) from which other agents will be evolved.
    */
   public IGAAgent createAgent()
   {  return new GAWallFollowingAgent();
   }
}
