package demos;
import java.awt.*;
import world.*;
import gui.*;
import actions.*;

/**
 * A class of procedural agents which inhabit grid-like worlds and which 
 * simply move randomly and shed light.
 * @author Derek Bridge
 */
public class FlittingLight
   extends ProceduralAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new agent.
    */
   public FlittingLight()
   {  flit = new Flit(TURN_PROBABILITY);
      lightShed = DEFAULT_LIGHT_SHED;
      PacmanGraphic graphic = new PacmanGraphic(this);
      graphic.setMouthAngle(0);
      graphic.setColour(Color.orange);
      physObjectGraphic = graphic;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the amount of light shed on each clock tick.
    * @param theLightShed the amount of light shed on each clock tick.
    */
   public void setLightShed(float theLightShed)
   {  lightShed = theLightShed;
   }

   /**
    * What to do on each clock tick.
    * These agents can move forward or change direction.
    * @param theTime an integer representing how many ticks have passed.
    */
   public void onTick(int theTime)
   {  flit.execute(this);
      cell.shedLight(lightShed);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private float lightShed;
   private Flit flit;
   private static final float TURN_PROBABILITY = 0.4f;
   private static final float DEFAULT_LIGHT_SHED = 0.8f;
}
