package demos;
import java.awt.*;
import world.*;
import gui.*;
import actions.*;

/**
 * A class of `agents', which simply move in straight lines and shed light.
 * @author Derek Bridge
 */
public class BouncingLight
   extends ProceduralAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new agent at a given cell, facing in a particular direction.
    */
   public BouncingLight()
   {  bounce = new Bounce();
      lightShed = DEFAULT_LIGHT_SHED;
      PacmanGraphic graphic = new PacmanGraphic(this);
      graphic.setMouthAngle(0);
      graphic.setColour(Color.orange);
      physObjectGraphic = graphic;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the amount of light shed on each clock tick.
    * @param theLightShed the amount of light shed on each tick.
    */
   public void setLightShed(float theLightShed)
   {  lightShed = theLightShed;
   }

   /**
    * What to do on each clock tick.
    * These agents move forward if they can; otherwise they turn
    * randomly.
    * @param theTime an integer representing how many ticks have passed.
    */
   public void onTick(int theTime)
   {  bounce.execute(this);
      cell.shedLight(lightShed); 
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private float lightShed;
   private Bounce bounce;

   private static final float DEFAULT_LIGHT_SHED = 0.8f;
}
