package actions;
import world.*;

/**
 * A class that represents move actions in grid-like world in which 
 * crashes cause reorientation and the agent can change direction 
 * rather than move.
 * @author Derek Bridge
 */
public class Flit
   extends Action
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new flit action.
    * @param theTurnProbability the probability that in any execution
    * the agent will change direction rather than move.
    */
   public Flit(float theTurnProbability)
   {  turnProbability = theTurnProbability;
      move = new Move();
      turn = new Turn(Turn.LEFT);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return "flit";
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Carry out the action in the world.
    * @param theAgent the agent who is executing the action.
    */
   public void execute(Agent theAgent)
   {  double outcome = Math.random();
      if (outcome < turnProbability)
      {  turn.setTurn(((int) (Math.random() * 2)), 
            ((int) (Math.random() * World.NUM_OF_COMPASS_POINTS)));
         turn.execute(theAgent);
      }
      else
      {  move.execute(theAgent);
         if (move.didCrash())
         {  turn.setTurn(((int) (Math.random() * 2)), 
               ((int) (Math.random() * World.NUM_OF_COMPASS_POINTS)));
            turn.execute(theAgent);
         }
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private float turnProbability;
   private Move move;
   private Turn turn;
}
